function map_tricolor(tricolor)

% tricolor can be one among {'ryg','rbg','rwg'}

% ryg runs smoothly from red,through yellow to green.
% Similarly, rwg and rbg vary smoothly from red to green,
% through white and black, respectively.
         
% map_tri is (3+99+99)-by-3 matrix of real numbers between 0.0 and 1.0. 
% Each row is a RGB vector that defines one color. 
% The first row defines the Red color, and the last row for the Green color,
% while median row defines the indicated color (yellow,white or black)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

map_tri=zeros(3+99+99,3);
tmap_tri=zeros(3+99+99,3);
switch tricolor
    case 'ryg',% color for red,yellow,green
        for i=1:size(map_tri,1)
            if i<=101
                map_tri(i,1)=1;
                map_tri(i,2)=0.01*(i-1);
                map_tri(i,3)=0;
            elseif i>=101
                map_tri(i,1)=1-(i-101)*0.01;
                map_tri(i,2)=1;                
                map_tri(i,3)=0;                
            end
        end
        for i=1:size(map_tri,1)
            tmap_tri(i,:)=map_tri(size(map_tri,1)-i+1,:);    
        end
    case 'rwg',% color for red,white,green
        for i=1:size(map_tri,1)
            if i<=101
                map_tri(i,1)=1;
                map_tri(i,2)=0.01*(i-1);
                map_tri(i,3)=0.01*(i-1);
            elseif i>=101
                map_tri(i,1)=1-(i-101)*0.01;
                map_tri(i,2)=1;
                map_tri(i,3)=1-(i-101)*0.01;
            end
        end
        for i=1:size(map_tri,1)
            tmap_tri(i,:)=map_tri(size(map_tri,1)-i+1,:);    
        end
    case 'rbg',% color for red,black,green
        for i=1:size(map_tri,1)
            if i<=101
                map_tri(i,1)=1-(i-1)*0.01;
                map_tri(i,2)=0;
                map_tri(i,3)=0;
            elseif i>=101
                map_tri(i,1)=0;
                map_tri(i,2)=(i-101)*0.01;
                map_tri(i,3)=0;
            end
        end
        for i=1:size(map_tri,1)
            tmap_tri(i,:)=map_tri(size(map_tri,1)-i+1,:);    
        end
end

colormap(tmap_tri);

return


